/*
 * Decompiled with CFR 0.152.
 */
package Project.Game.objects;

import BryceGraphs.ADTs.AdjacencyNode;
import BryceGraphs.Algorithms.GraphSearch;
import Data_Structures.Structures.BitSet;
import Data_Structures.Structures.HashingClasses.AArray;
import Data_Structures.Structures.List;
import Data_Structures.Structures.SingleLinkedList;
import Game_Engine.Engine.Objs.ImageB;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.GUI.Components.small.gui_handle;
import Game_Engine.SpriteFactories.ArrowImageFactory;
import Project.Editor.Components.Spr;
import Project.Game.objects.obj_mover;
import Project.Game.objects.obj_teleporter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import util.interfaces.Function;

public class obj_groundSquare
extends Obj
implements AdjacencyNode<obj_groundSquare> {
    public static obj_groundSquare last_move = null;
    public static obj_groundSquare last_drag = null;
    public static obj_groundSquare source = null;
    public static AArray<obj_groundSquare, SingleLinkedList<obj_groundSquare>> shortest_paths_from_move;
    public static SingleLinkedList<obj_groundSquare> empty_list;
    public static obj_mover current_mover;
    public static SingleLinkedList<obj_groundSquare> current_shortest_path;
    private boolean in_path;
    final BitSet direction_properties;

    static {
        empty_list = new SingleLinkedList();
        current_shortest_path = empty_list;
    }

    public obj_groundSquare(double x_in, double y_in, BitSet b) {
        super(x_in, y_in);
        this.sprite = Spr.ground_square;
        this.direction_properties = b;
    }

    @Override
    protected void update() {
        if (last_drag == this) {
            this.setSprite(Spr.ground_square_drag);
            return;
        }
        if (this.in_path) {
            this.setSprite(Spr.ground_square_in_path);
            return;
        }
        if (last_move == this) {
            this.setSprite(Spr.ground_square_move);
            return;
        }
        this.setSprite(Spr.ground_square);
    }

    @Override
    public void setSprite(BufferedImage spr) {
        if (this.sprite != spr) {
            this.redraw();
            this.sprite = spr;
            this.redraw();
        }
    }

    @Override
    public void global_mouseM(int mx, int my) {
        if (this.mouseCollision(mx, my)) {
            last_move = this.getCorrectSquare();
        }
    }

    @Override
    public void global_mouseD(int mx, int my) {
        if (this.mouseCollision(mx, my)) {
            last_drag = this.getCorrectSquare();
            obj_groundSquare.updateCurrentShortestPath();
        }
    }

    @Override
    public void global_mouseR() {
        if (last_drag == this) {
            obj_groundSquare.deHighlightShortestPath();
        }
    }

    @Override
    public void global_mouseP() {
        if (last_move == this) {
            obj_groundSquare.computeShortestPaths();
        }
    }

    private obj_groundSquare getCorrectSquare() {
        int w_h = this.sprite.getWidth() / 2;
        int h_h = this.sprite.getHeight() / 2;
        obj_mover mover = (obj_mover)this.instance_position(this.getX() + (double)w_h, this.getY() + (double)h_h, obj_mover.class);
        obj_groundSquare result = null;
        if (mover != null) {
            result = (obj_groundSquare)this.instance_position(mover.getX() + (double)w_h, mover.getY() + (double)h_h, obj_groundSquare.class);
        }
        return result == null ? this : result;
    }

    @Override
    public List<obj_groundSquare> getNeighbors() {
        List<obj_groundSquare> output = new List<obj_groundSquare>();
        obj_mover mover = (obj_mover)gui_handle.handle_held;
        int w = this.sprite.getWidth();
        int h = this.sprite.getHeight();
        double x = this.getX();
        double y = this.getY();
        if (mover.instance_place(x - (double)mover.holdOffsetX(), y - (double)mover.holdOffsetY(), obj_teleporter.class) != null) {
            return output;
        }
        BitSet b_mover = current_mover.getDirectionSet();
        BitSet b = b_mover.AND(this.direction_properties);
        if (b.getBit(0)) {
            this.addPosition(w, 0, output);
        }
        if (b.getBit(2)) {
            this.addPosition(0, -h, output);
        }
        if (b.getBit(4)) {
            this.addPosition(-w, 0, output);
        }
        if (b.getBit(6)) {
            this.addPosition(0, h, output);
        }
        if (b.getBit(1)) {
            this.addPosition(w, -h, output);
        }
        if (b.getBit(3)) {
            this.addPosition(-w, -h, output);
        }
        if (b.getBit(5)) {
            this.addPosition(-w, h, output);
        }
        if (b.getBit(7)) {
            this.addPosition(w, h, output);
        }
        return output;
    }

    @Override
    public int getNeighborSize() {
        return ((List)this.getNeighbors()).size();
    }

    private void addPosition(int x_inc, int y_inc, List<obj_groundSquare> L) {
        int y;
        obj_mover mover = (obj_mover)gui_handle.handle_held;
        int x = (int)this.getX() + x_inc;
        Obj o = mover.instance_place(x, y = (int)this.getY() + y_inc, obj_mover.class, new find_color(mover.index));
        if (o != null) {
            return;
        }
        o = mover.instance_place(x, y, obj_mover.class);
        if (o != null && (o = mover.instance_place(x += x_inc, y += y_inc, obj_mover.class)) != null) {
            return;
        }
        int x_max = x + mover.getW();
        int y_max = y + mover.getH();
        int xx = x;
        while (xx < x_max) {
            int yy = y;
            while (yy < y_max) {
                Obj o2 = mover.instance_position(xx, yy, obj_groundSquare.class);
                if (o2 == null) {
                    return;
                }
                yy += 64;
            }
            xx += 64;
        }
        o = this.instance_position(x, y, obj_groundSquare.class);
        if (o != null && o.getClass() == obj_groundSquare.class) {
            L.add((obj_groundSquare)o);
        }
    }

    private static void computeShortestPaths() {
        if (source == last_move) {
            return;
        }
        gui_handle h = gui_handle.handle_held;
        if (h instanceof obj_mover) {
            current_mover = (obj_mover)gui_handle.handle_held;
            shortest_paths_from_move = GraphSearch.shortestPaths(last_move);
        }
    }

    private static void updateCurrentShortestPath() {
        obj_groundSquare.deHighlightShortestPath();
        current_shortest_path = shortest_paths_from_move.lookup(last_drag);
        if (current_shortest_path == null) {
            current_shortest_path = empty_list;
        }
        obj_groundSquare.highlight_shortest_path();
    }

    private static void highlight_shortest_path() {
        Iterator<obj_groundSquare> iterator = current_shortest_path.iterator();
        while (iterator.hasNext()) {
            obj_groundSquare o;
            obj_groundSquare gs = o = iterator.next();
            gs.in_path = true;
        }
    }

    private static void deHighlightShortestPath() {
        Iterator<obj_groundSquare> iterator = current_shortest_path.iterator();
        while (iterator.hasNext()) {
            obj_groundSquare o;
            obj_groundSquare gs = o = iterator.next();
            gs.in_path = false;
        }
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public String toString() {
        return "X : " + (int)this.getX() / 64 + ", Y : " + (int)this.getY() / 64;
    }

    public static int getMoveLen() {
        return Math.max(current_shortest_path.size() - 1, 0);
    }

    public static obj_groundSquare getLastSquareInPath() {
        if (current_shortest_path.isEmpty()) {
            return last_move;
        }
        return current_shortest_path.getFirst();
    }

    @Override
    public void draw(ImageB image, AffineTransform AT) {
        super.draw(image, AT);
        this.drawRadialArray(image.getGraphics(), AT, ArrowImageFactory.getArrows(32), this.direction_properties);
    }

    private class find_color
    implements Function<Obj, Boolean> {
        private final int index;

        public find_color(int index) {
            this.index = index;
        }

        @Override
        public Boolean eval(Obj input) {
            if (input instanceof obj_mover) {
                if (((obj_mover)input).index == this.index) {
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

